import simulations_database.simulations_database as sdb
from sim_definitions import *
import ipywidgets as widgets

def create_or_get_set(base, system_label, tag):
    #Create set
    if sdb.SimulationScenarioSet.objects(name=base):
        sss = sdb.SimulationScenarioSet.objects.get(name=base)
    else:
        sss = sdb.SimulationScenarioSet(
            name=base,
            meta_data={'System': system_label, 'Tag': tag,
                       'Scenarios': []
                      }
        )
        sss.save()
    return sss

def create_replace_job_months(sss, base, model,  months, input_data, job_image, timeframe_h, tag_map):
    for i in months:

                label = base + '_month_'+str(i)
                if sdb.Job.objects(name=label):
                    j = sdb.Job.objects.get(name=label)
                    j.delete_and_jobs()
                    j.delete()
                    j.save()

                if not sdb.Job.objects(name=label):


                    rc = {'Month': i}
                    sr = sdb.Job(           
                            name=label,
                            meta_data=rc,

                        job_output_id=ObjectId()
                        )
                    add_job_spec(sr, i, model, input_data, job_image, tag_map, timeframe_h)
                    sss.set.append(sr)
                    rc.update({
                           'Cases': [len(sss.set)-1]
                           })
                    sss.meta_data['Scenarios'].append(rc)

    sss.save()

def print_links(sss):
    
    for i, s in enumerate(sss.set):
       # print('Index: ', i, ' - ', s.job_output_alias)
        display(widgets.HTML('<a target="_blank" href=\"http://209.222.108.162:8000/sim_app/new_viz/'+s.job_output_alias+'/\">'+s.job_output_alias+'</a>'))