from gcloud_jobs.job import Job, Status, NameSpace
from gcloud_jobs.bucket import Bucket

from ftpsync.targets import FsTarget
from ftpsync.ftp_target import FtpTarget
from ftpsync.synchronizers import DownloadSynchronizer, UploadSynchronizer
import os
import glob
import json
import sys, traceback
import datetime
import pandas as pd
import numpy as np
#from sim_tools.job import simulation_job_single as simulation_job
from sim_tools.job import simulation_job
from contextlib import redirect_stdout
#from contextlib import redirect_stderr
from copy import deepcopy
from functools import reduce  # forward compatibility for Python 3
import operator
import jsonpickle
import jsonpickle.ext.numpy as jsonpickle_numpy
jsonpickle_numpy.register_handlers()
import signal
global terminated
terminated = False
import threading

from time import sleep, time

class GracefulKiller:
    kill_now = False
    kill_ack = False

    def __init__(self):
        signal.signal(signal.SIGINT, self.exit_gracefully)
        signal.signal(signal.SIGTERM, self.exit_gracefully)

    def exit_gracefully(self, signum, frame):
        global terminated
        terminated= True
        self.kill_now = True

def objective_wrapper(X):
    global objective_func_
    return objective_func_(X)

def getFromDict(data_struct, mapList):
    # return reduce(operator.getitem, mapList, dataDict)
    # print(mapList)
    key = mapList[0]

    if isinstance(data_struct, dict):
        lower_level = data_struct[key]

    elif isinstance(data_struct, list):
        lower_level = next(item for item in data_struct if item["name"] == key)
    else:
        raise ValueError('bad map')

    if len(mapList[1:]) > 0:
        lower_level = getFromDict(lower_level, mapList[1:])

    return lower_level


def setInDict(dataDict, mapList, value):
    # print(mapList)
    if len(mapList) > 1:
        getFromDict(dataDict, mapList[:-1])[mapList[-1]] = value
    else:
        dataDict[mapList[-1]] = value



def check_create_dir(directory):
    if not os.path.exists(directory):
        os.makedirs(directory)



def run_reports(report_dir, report_definitions, job_reference, namespace, output_folder_path, bucket=None, tags=False):
    import papermill as pm
    report_dir = os.getcwd() + '/' + report_dir

    tags_=[]
    for rd in report_definitions:

        template_folder = report_dir + '/' + rd['template']

        report_out_file = rd['name']

        report_out_file_ipynb = template_folder+'/' + report_out_file + '.ipynb'

        params = rd['parameters']
        params.update({
            'output_dir': report_dir + '/'+rd['template'],
            #'data_folder':
            'auto_generated': True
                       })


        if not tags:
            cwd_ = os.getcwd()
            os.chdir(template_folder)
            print('temp folder: ', template_folder)
            from nbconvert.preprocessors.execute import DeadKernelError
            tries = 0
            success = False
            while not success and tries<3:
                tries+=1
                try:
                    pm.execute_notebook(
                        template_folder + '/' + rd['template'] + '.ipynb',
                        report_out_file_ipynb,
                        parameters=params
                    )
                    success = True
                except DeadKernelError:
                    print('kernel died! Trying: ', tries)

            report_params = deepcopy(params)
            report_params.update({'bucket': {'name': bucket.name, 'base_folder': bucket.base_folder}})

            from google.cloud import datastore
            from gcloud_jobs.job_methods import ds_client

            key_space = 'sim_proj_manager_reports-v1'

            #print('Report Parameters: ', job_reference + '-' + namespace)

            param_file = 'params.json'
            full_path_params = output_folder_path +'/'+param_file
            with open(full_path_params, 'w') as f:
                json.dump(params, f)

            if bucket:
                bucket.upload_file(full_path_params, full_path_params)

            with ds_client.transaction():

                key = ds_client.key(key_space, job_reference + '-' + namespace)
                entity = ds_client.get(key=key)

                entity = datastore.Entity(key, exclude_from_indexes=['params'])

                entity.update({
                    'namespace': namespace,
                    'job_reference': job_reference,
                    'params': json.dumps(report_params)

                })

                ds_client.put(entity)

            os.chdir(cwd_)
        else:
            tag_file = template_folder+'/tags.json'
            print('Tag file: ',tag_file)
            if os.path.exists(tag_file):
                print('Found tags in file: '+tag_file)
                with open(tag_file,'r') as tf:
                    new_tags=json.load(tf)
                    tags_+= new_tags['tags']








    return set(tags_)



class FileDW():

    def __init__(self, file, bucket, file_count=0):
        self.bucket = bucket
        self.file = file

        self.data_map = []
        self.complete_map = []
        self.start = datetime.datetime(2020,1,1)

        self.data_blocks = []
        self.complete_data_block = []

        self.max_blocks = 8700
        self.file_counter = file_count


    def flush(self, force=False):


        if force or len(self.data_blocks)>= self.max_blocks:

            if len(self.data_blocks)>0:
                self.df = pd.DataFrame(np.array(self.data_blocks), columns=self.data_map)

                out_file = self.file+'_'+str(self.file_counter)+'.pqt'
                self.df.to_parquet(out_file)
                self.file_counter += 1
                self.data_blocks = []

                self.bucket.upload_file(out_file, out_file)



class Debouncer():
    def __init__(self):
        self.last = time()
        self.debounce_dt = 10

    def debounce(self):
        if time() - self.last > self.debounce_dt:
            self.last = time()
            return False
        return True



def optimize(obj_funct, resume=False, bucket = None, optimizer_args={}):
    import rbfopt

    state_file = 'optimizer_state.dat'

    #TODO get settings from job spec
    settings_dict = dict(
        minlp_solver_path='/sim/bonmin/bonmin',  max_evaluations=1000,
        #num_cpus=3,
        target_objval=1,
        #save_state_interval=1,
        #save_state_file=state_file
    )
    if 'settings' in optimizer_args:
        settings_dict.update(optimizer_args['settings'])

    settings = rbfopt.RbfoptSettings(**settings_dict)

    n_dim = 2

    #N_BHS, N_EMA

    bb = rbfopt.RbfoptUserBlackBox(n_dim, np.array(optimizer_args['limits']['min']), np.array(optimizer_args['limits']['max']),
                                   np.array(['I', 'I']), obj_funct)

    alg = rbfopt.RbfoptAlgorithm(settings, bb)

    #if os.path.exists(state_file):
    #    alg.load_from_file()

    val, x, itercount, evalcount, fast_evalcount = alg.optimize()
    with open('optim_result.txt','w') as f:
        with redirect_stdout(f):
            print('Min obj fun value: ',val)
            print('x: ', x)
            print('iter count: ', itercount)
            print('eval count: ', evalcount)
    if bucket:
        bucket.upload_file('optim_result.txt','/optim_result.txt')






from google.cloud import storage
def get_RF_files():
    client = storage.Client()
    bucket = client.get_bucket('rf-files.numerously.com')

    for rf_file in ['R1234yf_333_6_file.dat', 'R1234zee_333_6_file.dat', 'R134A_333_6_file.dat', 'R410A_333_6_file.dat', 'R407C_20190606.dat']:

        # https://console.cloud.google.com/storage/browser/[bucket-id]/

        blob = bucket.get_blob(rf_file)
        if blob:
            blob.download_to_filename('thermodynamics/Interp/Interp/'+rf_file)
        else:
            print('didnt find: '+rf_file)







import sys


def main(*args, exit=True):
    global terminated
    try:
        debouncer = Debouncer()

        killer = GracefulKiller()

        def continue_callback():

            if killer.kill_ack:
                return False
            else:
                if killer.kill_now:
                    killer.kill_ack = True
                    print("sig_term received!")
                    # job_out.save_debounce(force=True)
                    return False

            return True
        """
        def check_terminated(continue_):
            while True:

                if not continue_():
                    #Set statue!!
                    progress_callback(0, status='terminated', force=True, prog_meta="Terminated")
                    sys.exit(0)


                sleep(0.1)

        stop_threads = False
        import threading
        t1 = threading.Thread(target=check_terminated, args=(continue_callback,))
        t1.start()

        #HERE!!!!
        #t1.join()
        #print('thread killed')
        """
        #Create data folder
        check_create_dir('/work/data')
        #Setup job
        os.chdir('/work')
        # Get original working dir
        cwd_ = os.getcwd()

        job_ref = args[0][1]
        namespace = args[0][2]
        status_key = args[0][3]

        job = Job(job_ref, NameSpace(namespace))
        spec = job.get_definition()
        job_spec =json.loads(spec['job_spec'])

        is_optimization = job_spec['optimize']
        resume_optimization = job_spec['resume_optimize']
        optimizer_arguments = job_spec['optimizer_arguments']




        if is_optimization:
            job_spec['resume_optimize'] = True
            print('Optimizer arguments:')
            print(optimizer_arguments)
            spec['job_spec']=json.dumps(job_spec)
            job.redefine(spec)
            print('spec redefined!')

        bucket = Bucket(base_folder=namespace + '/' + job_ref)

        def synchronize(direction='down'):
            os.chdir(cwd_)
            local = FsTarget('.')
            user = job_spec['ftp_user']  # "robot.user"
            passwd = job_spec['ftp_pass']  # "Robottobor"
            remote_path = job_spec['remote_path']
            remote_server = job_spec['ftp_ip']  # "10.132.0.78"
            remote = FtpTarget(remote_path, remote_server, username=user, password=passwd)


            if direction == 'up':
                opts = {"force": True, "delete_unmatched": True, "verbose": 0}
                s = UploadSynchronizer(local, remote, opts)
                #pass
            else:
                opts = {"force": True, "delete_unmatched": True, "verbose": 0}
                s = DownloadSynchronizer(local, remote, opts)
            s.run()
        from google.api_core.exceptions import Aborted
        from gcloud_jobs.pubsub.cloud_pubsub import publisher, project_id
        topic_path = publisher.topic_path(project_id, job.namespace.name)
        print(topic_path)
        #ps = Pubsub(job.namespace.name + '-' + job.job_ref)
        def progress_callback(progress, prog_meta=None, status='running', force=False):

            if not debouncer.debounce() or force:
                attrs=dict(
                    prog_meta=prog_meta if prog_meta else "", status=status,
                    progress=str(progress),
                    datetime=datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")
                )

                publisher.publish(topic_path, str.encode(job_ref), **attrs)

                #failures = 0
                #successful = False
                #while failures<10 and (force or failures == 0) and not successful:
                #    try:
                #        job.set_status(Status(status=status, progress=progress, status_description=prog_meta))
                #        successful=True
                #    except Aborted:#

                        #sleep(15)
                        #failures+=1
                        #print('Failing updating status! ',failures)





        def simulation_job_(sim_specification, imports, report_definitions, file_dw):

            # Get persistent tags to save
            tags = run_reports('reports', report_definitions, job_ref, namespace, '', tags=True, bucket=bucket)
            print('the persistent tags: ', len(tags))

            if 'persistent_tags' in sim_specification['sim_spec'] and sim_specification['sim_spec']['persistent_tags']=='ALL':
                sim_specification['sim_spec']['persistent_tags'] = 'ALL'
            elif len(tags) > 0:
                print('setting persistent tags. ', len(tags))
                sim_specification['sim_spec']['persistent_tags'] = tags

            # Handle dynamic model imports

            import importlib.util
            for i in imports:
                spec = importlib.util.spec_from_file_location(i[1], "/work/models/" + i[0] + "/" + i[0] + ".py")
                globals()[i[1]] = importlib.util.module_from_spec(spec)
                spec.loader.exec_module(globals()[i[1]])

            #print(imports)


            # Run simulation from the sim components directory
            os.chdir('/sim/sim_components/sim_components')

            # Make sure the RF files is in place
            get_RF_files()

            # job_mongodb_store.main(job_id, job_alias, *(spec_id,))


            # run simulation
            simulation_job.main(0, {}, sim_specification, progress_callback=progress_callback, dw=file_dw,
                                continue_callback=continue_callback, **{})

            # change back to original working dir
            os.chdir(cwd_)

        def get_iteration_spec(X, sim_specification):
            iteration_spec = deepcopy(sim_specification)

            iteration_spec['model_spec']['kwargs_loaded'] = jsonpickle.loads(iteration_spec['model_spec']['kwargs'])

            iteration_spec['model_spec'].pop('kwargs')

            # convert X to parameters and update in job_spec

            par_map = ['specification.items.BHS.N1', 'specification.items.BHS.N2', 'specification.items.EP.N EMA']
            for par_map_, x in zip(par_map, X):
                setInDict(iteration_spec['model_spec']['kwargs_loaded'], par_map_.split('.'), x)

            return iteration_spec

        def get_report_definitions_modified(output_folder_path, report_definitions, costfile, post_fix, X):
            report_definitions_modified = deepcopy(report_definitions)
            for rd in report_definitions_modified:


                if len(X)>0:
                    setInDict(rd['parameters']['scenario'], 'system_definition.items.EP.item.N_EMA'.split('.'), X[2])
                    setInDict(rd['parameters']['scenario'], 'system_definition.items.BHS.item.N1'.split('.'), X[0])
                    setInDict(rd['parameters']['scenario'], 'system_definition.items.BHS.item.N2'.split('.'), X[1])

                rd['parameters']['post_fix'] = post_fix

                rd['parameters'].update({'cost_file': costfile, 'data_folder': output_folder_path
                                         })


            return report_definitions_modified


        #sync folder
        synchronize()

        #define optimization

        #define objective_function

        def simulation(sim_specification, report_definitions, file_dw, output_folder_path, optimizing=True, upload=False):


            try:
                # Run the simulation
                if not job_spec['report_only']:
                    simulation_job_(sim_specification, job_spec['imports'], report_definitions, file_dw)
                progress_callback(100, status='running', force=True, prog_meta='Running reports')
                run_reports('reports', report_definitions, job_ref, namespace, output_folder_path, bucket=bucket)
            except:
                print('Error in simulation or report!')
                print(traceback.format_exc())
                #if upload:

                synchronize(direction="up")
                raise
            if upload and not optimizing:
                synchronize(direction="up")
        global optim_history
        optim_history = []
        sim_specification = job_spec['sim_specification']
        report_definitions = job_spec['report_definitions']

        optim_history_file = "/work/optim_history.json"

        if resume_optimization:
            if bucket.exists(optim_history_file):
                bucket.download_file(optim_history_file, optim_history_file)
                print('history downloaded')

        #global optim_history


        if os.path.exists(optim_history_file) and resume_optimization:
            with open(optim_history_file, 'r') as f:

                optim_history = json.load(f)['history']


                print('history read')

        def objective_func(X):
            configurations = {
                0: (0, 0),
                1: (1, 1),
                2: (2, 1),
                3: (3, 1),
                4: (2, 2),
                5: (3, 2),
                6: (4, 2),
                7: (3, 3),
                8: (5, 2),
                9: (6, 2),
                10: (7, 2),
                11: (4, 4),
                12: (5, 4),
                13: (6, 4),
                14: (5, 5),
                15: (6, 5),
                16: (6, 6),
                17: (7, 6),
                18: (7, 7),
                19: (8, 7),
                20: (8, 8),
                21: (9, 8),
                22: (9, 9),
                23: (10, 9),
                24: (10, 10),
                25: (11, 10),
                26: (11, 11),
                27: (12, 11),
                28: (12, 12),
                29: (13, 12),
                30: (13, 13),
                31: (14, 13),
                32: (14, 14),
                33: (15, 15),
                34: (16, 16),
                35: (17, 17),
                36: (18, 18),

            }
            X = [int(x) for x in list(X)]
            X = list(configurations[X[0]]) + [X[1]]
            global optim_history

            post_fix = 'opt_' + '_'.join([str(x) for x in X]).replace('.', '-')

            historic_result = next((item for item in optim_history if item["key"] == post_fix), None)



            # compose the output file name
            output_folder_name = post_fix
            output_folder_path = '/work/data/'+output_folder_name
            output_folder_path_rel = '../../data/' + output_folder_name

            check_create_dir(output_folder_path)
            output_folder_path+='/'

            output_file_name_json = output_folder_path+'cost.json'
            # If optimizing capture all the output to a log file
            #stdout_path = output_folder_path + 'stdout.txt'
            #stderr_path = output_folder_path + 'stderr.txt'
            #f = open(stdout_path, 'w')
            #f_err = open(stderr_path, 'w')
            #with redirect_stdout(f):
               #with redirect_stderr(f_err):
            try:




                iteration_spec = get_iteration_spec(X, sim_specification)


                report_definitions_modified = get_report_definitions_modified(output_folder_path_rel, report_definitions, output_file_name_json, post_fix, X)

                if historic_result:
                    if job_spec['report_only']:
                        #print('Rep mod: ', report_definitions_modified)
                        #for rd in report_definitions_modified:
                        print('Downloading from:')
                        print(bucket.base_folder+output_folder_path)
                        list_blobs = bucket.list(bucket.base_folder+output_folder_path)

                        check_create_dir(output_folder_path)
                        for b in list_blobs:

                                if '.pqt' in b.name[-4:] or '.json' in b.name[-5:]:
                                    print(b.name)
                                    # print(b.name)
                                    file = b.name.split('/')[-1]
                                    # print(file)
                                    with open(output_folder_path + '/' + file, 'wb') as f:
                                        b.download_to_file(f)
                        print('downloaded data files')


                        run_reports('reports', report_definitions_modified, job_ref, namespace, output_folder_path, bucket=bucket)
                    return historic_result['cost']

                file_dw = FileDW(output_folder_path + 'data', bucket)
                simulation(iteration_spec, report_definitions_modified, file_dw, output_folder_path, optimizing=True)

                #load the output file
                with open(output_file_name_json, 'r') as fo:
                    cost = json.load(fo)
                #if (cost['par_vals'] == X).all():
                print(cost)

                bucket.upload_file(output_file_name_json, output_file_name_json)

                optim_history.append({'key': post_fix, 'cost': cost['value'], 'param': X, 'data_folder': output_folder_path, 'removed': False})
                #cost={}
                #cost['value'] = 8
                #optim_history.append(
                #    {'key': post_fix, 'cost': cost['value'] , 'param': X, 'data_folder': output_folder_path,
                #     'removed': False})
                optim_history = sorted(optim_history, key=lambda k: k['cost'])

            except:
                print(traceback.format_exc())
                #killer.kill_now = True


                    #import subprocess
            len_hist_keep = 3
            if len(optim_history)>len_hist_keep:
                for c in optim_history[len_hist_keep:]:
                    if os.path.exists(c['data_folder']) and not c['removed']:
                        #print('Deleting datafiles in: ', c['data_folder'])
                        pass
                        # Get a list of all the file paths that ends with .txt from in specified directory
                        #fileList = glob.glob(c['data_folder']+'*.pqt')
                        #fileList += glob.glob(c['data_folder'] + '*.html')

                        # Iterate over the list of filepaths & remove each file.
                        #for filePath in fileList:
                         #   if os.path.exists(filePath):
                         #       os.remove(filePath)
                         #   if bucket.exists(filePath):
                         #       bucket.delete(filePath)

                        #print(shutil.rmtree(c['data_folder'][:-1], ignore_errors=True))
                        #c['removed'] = True

            #optim_history=optim_history[:10]

            with open(optim_history_file, 'w') as ohf:
                json.dump({'history': optim_history}, ohf)
            bucket.upload_file(optim_history_file,optim_history_file)
            print('History uploaded')
            #bucket.upload_file(stdout_path, stdout_path)
            #bucket.upload_file(stderr_path, stderr_path)

            return cost['value']
                    #else:
                    #    raise ValueError("Parameters in output mismatch!")


        #TODO make this a param
        optimizing = True

        if is_optimization:
            print('Begin optimization procedure')

            global objective_func_
            objective_func_ = objective_func
            #optimizer_args=optimizer_arguments{'optimizer_settings'} if optimizer_settings in optimizer_arguments else {}
            optimize(objective_wrapper, resume=resume_optimization, bucket=bucket, optimizer_args=optimizer_arguments)
        else:
            print('Run simulation once')
            X=[]
            post_fix =''
            output_folder_name = 'sim'
            output_folder_path = '/work/data/' + output_folder_name
            output_folder_path_rel = '../../data/' + output_folder_name

            check_create_dir(output_folder_path)
            output_folder_path += '/'

            output_file_name_json = output_folder_path + 'cost.json'

            file_dw = FileDW(output_folder_path + 'data', bucket)
            report_definitions_modified = get_report_definitions_modified(output_folder_path_rel, report_definitions,
                                                                          output_file_name_json, post_fix, X)

            simulation(sim_specification, report_definitions_modified, file_dw, output_folder_path, optimizing=False, upload=True)

            
        progress_callback(100, status='finished', force=True)
        return 'finished'

    except:
        print(traceback.format_exc())

        if not terminated:
            progress_callback(0, status='failed', force=True)
        #return 'failed'


    finally:

        if terminated:
            progress_callback(0, status='terminated', force=True, prog_meta='SIG TERM Received!')
        sys.exit(0)

if __name__ == "__main__":
    main(sys.argv)
