from job_worker import job_mongodb_store
from ftpsync.targets import FsTarget
from ftpsync.ftp_target import FtpTarget
from ftpsync.synchronizers import DownloadSynchronizer, UploadSynchronizer
import os


def check_create_dir(directory):
    if not os.path.exists(directory):
        os.makedirs(directory)


def save_notebook():
    return display(Javascript("IPython.notebook.save_notebook()"),
                   include=['application/javascript'])


def output_HTML(read_file, output_file):
    from nbconvert import HTMLExporter, PDFExporter
    import codecs
    import nbformat
    #exporter = HTMLExporter(template_file='nbextensions.tpl', default_template_path='/usr/local/lib/python3.6/site-packages/jupyter_contrib_nbextensions/templates')
    exporter = HTMLExporter(template_file='nbextensions.tpl',
                            default_template_path='/usr/local/lib/python3.6/site-packages/nbconvert/templates/html')
    #exporter = HTMLExporter()/usr/local/lib/python3.6/site-packages/nbconvert/templates/html#
    # read_file is '.ipynb', output_file is '.html'
    output_notebook = nbformat.read(read_file, as_version=4)
    output, resources = exporter.from_notebook_node(output_notebook)
    codecs.open(output_file, 'w', encoding='utf-8').write(output)

    # exporter_pdf = PDFExporter(template_file='nbextensions.tpl', default_template_path='/etc/jupyter')
    # read_file is '.ipynb', output_file is '.html'
    # output_notebook = nbformat.read(read_file, as_version=4)
    # output, resources = exporter_pdf.from_notebook_node(output_notebook)
    # codecs.open(output_file_pdf, 'w', encoding='utf-8').write(output)


def run_reports(report_dir, job_ref, report_definitions):
    import papermill as pm
    report_dir = os.getcwd() + '/' + report_dir
    print(report_dir)
    check_create_dir(report_dir + '/ipynb')
    check_create_dir(report_dir + '/html')
    # check_create_dir(report_dir+'/pdf')
    for rd in report_definitions:

        template_folder = report_dir + '/ipynb/' + rd['template']

        report_out_file = rd['name']

        report_out_file_ipynb = template_folder+'/' + report_out_file + '.ipynb'
        report_out_file_html = report_dir + '/html/' + report_out_file + '.html'
        # report_out_file_pdf = report_dir+'/pdf/'+report_out_file + '.pdf'

        params = rd['parameters']
        params.update({'job_reference': job_ref, 'output_dir': report_dir + '/ipynb/'+rd['template']})


        os.chdir(template_folder)

        pm.execute_notebook(
            template_folder + '/' + rd['template'] + '.ipynb',
            report_out_file_ipynb,
            parameters=params
        )

        output_HTML(report_out_file_ipynb, report_out_file_html)


def main(job_id, job_alias, *args, **kwargs):

    spec_id = kwargs['spec_id']

    local = FsTarget('.')
    user = "robot.user"
    passwd = "Robottobor"



    remote_path = kwargs['remote_path']

    print(remote_path)

    remote_server = "10.132.0.78"

    remote = FtpTarget(remote_path, remote_server, username=user, password=passwd)

    opts = {"force": True, "delete_unmatched": True, "verbose": 3}

    s = DownloadSynchronizer(local, remote, opts)
    s.run()

    cwd_ = os.getcwd()
    imports = kwargs['imports']
    import importlib.util


    for i in imports:

        spec = importlib.util.spec_from_file_location(i[1], "models/"+i[0]+"/"+i[0]+".py")
        globals()[i[1]] = importlib.util.module_from_spec(spec)
        spec.loader.exec_module(globals()[i[1]])

    print('working path: ', cwd_)
    print(spec_id)
    print('doing the mong job!')

    import sys

    sys.path.append('/sim/sim_components/sim_components/thermodynamics')

    job_mongodb_store.main(job_id, job_alias, *(spec_id,))

    os.chdir(cwd_)


    report_definitions = kwargs['report_definitions']

    run_reports('reports', job_alias, report_definitions)

    opts = {"force": False, "delete_unmatched": False, "verbose": 3}



    s = UploadSynchronizer(local, remote, opts)
    # s = DownloadSynchronizer(local, remote, opts)

    s.run()

if __name__ == "__main__":
    project = 'new_project'
    main(0, 'test',**dict(
        remote_path = "/opt/shared_folders/EM_simulations/Yearly_Simulations/Simulation_Project_Manager/v03/project_tool/projects/"+project+'/results/'+'group1'+'/'+'scenario1',
        report_definitions = [{'name': 'test', 'template': 'test', 'parameters': {'par': 1}}],

    ))

