import numpy as np


def search_cycle(data_sets, window, min_periods, min_length, len_data):

    min_cost = np.inf
    min_cost_length = np.NaN
    min_averages =  {k: np.NaN for k in data_sets.keys()}
    periods=0
    if len_data>window:
        for n in range(int(min_length*min_periods), int(np.floor(window / min_periods))):
            cost = 0
            averages = {}
            periods=int(np.floor(window/n))

            for k, v in data_sets.items():

                test_data = np.array(v['data'][-periods * n:],np.float64)

                data_section = test_data.reshape((periods, n))
                if v['search']:
                    std_section = np.std(data_section, 0)

                    cost += np.sum(np.abs(std_section)) / len(std_section)

                if v['avg']:
                    averages[k]= np.average(data_section)
                else:


                    averages[k] = np.average(data_section[:,-1]-data_section[:,0])/np.float64(n-1)


            if cost < min_cost:
                min_cost = cost
                min_cost_length = n
                min_averages = averages

        period_data = {}

        for k, v in data_sets.items():
            test_data = np.array(v['data'][-periods * min_cost_length:], np.float64)
            data_section = test_data.reshape((periods, min_cost_length))

            period_data[k] = data_section

    return {'cost': min_cost, 'period': min_cost_length, 'n_per':periods, 'averages': min_averages, 'data': period_data}




if __name__ == '__main__':
    min_periods = 3
    min_length = 100
    rep = 4
    l_set = 1000
    len_data = rep * l_set
    window = (rep-.9) *l_set
    v=2.5
    data_sets = {'avg': {'search': True, 'avg':True, 'data': np.tile(np.arange(l_set)*v, rep)}, 'diff': {'search': False, 'avg':False, 'data': np.tile(np.arange(l_set)*v, rep)+4}}
    # print(data_sets)

    print(search_cycle(data_sets, window, min_periods, min_length, len_data))

