
from copy import deepcopy
from datetime import datetime
from collections import OrderedDict
import jsonpickle
import jsonpickle.ext.numpy as jsonpickle_numpy
jsonpickle_numpy.register_handlers()
import json
from multiprocessing import Process
import requests
from job_worker.job import main as job_main

from job_worker.job_models import *
import simulations_database.simulations_database as sdb

from plotly.offline import download_plotlyjs, init_notebook_mode, plot, iplot
from plotly import __version__
import plotly.plotly as py
import plotly.graph_objs as go 

import ipywidgets as widgets
from IPython.display import clear_output
import time
from inspect import getsource

import scipy
from pip._internal.utils.misc import get_installed_distributions

def makeplot(layo,y,range_slider=False, fill=None):
        data=[]
        for i, s in enumerate(y):
            if fill:
                if i>0:
                    d=go.Scatter(x=s[0],
                       y=s[1], name=s[2], fill=fill[i])
                else:
                    d=go.Scatter(x=s[0],
                       y=s[1], name=s[2], fill=fill[i])
            else:
                d= go.Scatter(x=s[0],
                   y=s[1], name=s[2])
            data.append(d)
            
        
                   
        
        if range_slider:
            layout = dict(
                title=layo[0],
                yaxis=dict(
                    title=layo[2],
                ),
                xaxis=dict(
                    title=layo[1],
                    rangeselector=dict(
                        buttons=list([
                            dict(count=1,
                                 label='1m',
                                 step='month',
                                 stepmode='backward'),
                            dict(count=6,
                                 label='6m',
                                 step='month',
                                 stepmode='backward'),
                            dict(count=1,
                                label='YTD',
                                step='year',
                                stepmode='todate'),
                            dict(count=1,
                                label='1y',
                                step='year',
                                stepmode='backward'),
                            dict(step='all')
                        ])
                    ),
                    rangeslider=dict(),
                    type='date'
                )
            )
        else:
            layout = dict(
                title=layo[0],
                xaxis=dict(
                    title=layo[1],
                    ),
                yaxis=dict(
                    title=layo[2],
                
                    )
            )
                

        fig = dict(data=data, layout=layout)
        iplot(fig)
           
def makebar(layo,y,stack=False):
        data=[]
        for s in y:
            data+=[go.Bar(x=s[0],
                   y=s[1], name=s[2])]
        
        
        layout = dict(
            title=layo[0],
            xaxis=dict(
                title=layo[1],
                ),
            yaxis=dict(
                title=layo[2],

                )
        )
        if stack:
            layout['barmode']='stack'
        fig = dict(data=data, layout=layout)
        iplot(fig)    
  

def add_job_spec(Scenario, month, energy_system,input_data,job_image, tag_map, timeframe_h=24, interp=None):
    start_year = 2016
       
    start = datetime(start_year, 1, 1, 0, 0, 0, 0)
    
       
    kwargs=deepcopy(energy_system)
    
    
    print('Month: ', month)
    #BHS_init_month=[4,4,5,5.5,6,7,8,7,7,6.5,6,5]
    #BHS_init_month=[3,3,4,5,8,11,13,13,10,7,5,4]
    #BHS_init_month=[8 for i in range(12)]
    BHS_init_month=[3.4, 2.8, 3.5, 4.1, 5, 10, 11.9, 12.7, 12.6, 10.5, 5.1, 3.6]
    
    assert len(BHS_init_month)==12, 'There must be exactly 12 months in BHS init!'
    #base_alias = 'ikea_kallered_sim5_'
    
    
    start = datetime(2016, month, 1, 0, 0, 0, 0)
    
    kwargs=deepcopy(energy_system)
    kwargs['specification']['items']['BHS_A']['T0']=BHS_init_month[month-1]
    
    
    #print('ix ',month-1)
    sim_specification = {
        'model_spec': {'class_name': 'sim_components.systems.energy_system_integration.SubsystemPrescribed', 
                       'args': jsonpickle.dumps([]),
                       'kwargs': jsonpickle.dumps(kwargs), 'interp': jsonpickle.dumps(interp if interp else {} ), 
                       'input_stream': {'job_alias': input_data, 'tag_map': tag_map, 'stream_ix': month-1, 'solve_all':False},
                       'visualisation': 'Kallered',
                      },
        
        'sim_spec': {'dt': 3600, 't_0': 0, 't_end':  timeframe_h*3600, 'dt_internal': .05, 
                     #'persistent_tags': pt, 
                     'persistent_tags': {'no_tmp': True, 'level':3},
                     'n_dt_update': -1, 
                     'start': start.isoformat(), 'stop_tag': 'stop',
                    }
    }
    
    
    #EP Reg mode ????
   
    from inspect import getsource
    
    
    targets = {"kubernetes": {
                'reraise_errors': False,
                "working_dir": '/sim/sim_components/sim_components',
                'script': 'job_worker.job_mongodb_store',
                "job-image": job_image,
                "node-pool": 'sim-worker-1cpu-preemptive',
                "cpu-request": 0.6}
             }
    
    spec={
        'on_exist': {'finished': 'return', 'not_finished': 'resume'},
        'script': 'sim_tools.job.simulation_job',
        #'pre_methods': [{'source': pre_source, 'kwargs': {}}],
        #'post_methods': [{'source': post_source, 'kwargs': {'dt': dt, 't_total': t_total, 't_warm_up': t_warm_up}}],
        'args': [sim_specification],
        'kwargs': {},
        'targets': targets
    }
    alias = Scenario.name
    if not JobSpec.objects(alias=alias):
        js = JobSpec(alias=alias, spec=spec)

    else:
        js = JobSpec.objects.get(alias=alias)
        js.spec = spec

    js.job_id = str(ObjectId())
    js.save()
    
    Scenario.job_spec = js
    Scenario.job_output_alias = 'Job_'+alias
    Scenario.save()

def start_job(scenario, **target):
    job_id = scenario.job_output_id
    js=scenario.job_spec
    
    #print('starting job: ', job_def)
    job_alias =scenario.job_output_alias
    #scenario.job_output_alias = job_aliassimulation-components
    
    if not JobControl.objects(job_alias=job_alias):
        jc = JobControl(job_alias=job_alias, action="Continue")
        
    else:
        jc = JobControl.objects.get(job_alias=job_alias)
        jc.action="Continue"
    
    
    jc.save()
    scenario.job_control = jc
    scenario.save()
    
    job_def_target = {
        'reraise_errors': True,
        'working_dir': target['working_dir'],
        'script': 'job_worker.job_mongodb_store',
        'args': [str(js.id)],
        'kwargs': {}
        }
    
    
    
    if target['target'] == 'Kubernetes':
        job_def_target['reraise_errors']=False
        
        
    
        args = {"job-id":str(job_id),
                "job-alias":job_alias, 
                "job-def":json.dumps(job_def_target), 
                "job-image": target['image'],
                "node-pool": target['node-pool'],
                "cpu-request": target['cpu-request']}
    
        response=requests.post("http://35.240.63.157:5362/api/v1.0/jobs", data=args)
        print(response)
        
    
    if target['target'] == 'LocalProcess':
        
        args = [['script_name', job_id, job_alias, json.dumps(job_def_target)]]
        
        import os
        os.chdir(target['working_dir'])
        
        job_proc = Process(target=job_main, args=args)
        job_proc.start()
    else:
        job_proc = None
        
    return job_alias, job_proc

def start_local(scenario, working_dir=None):
        if working_dir== None:
            try:
                working_dir=[i.location for i in get_installed_distributions() if 'simulation-components'  in i.project_name][0]+'/sim_components'
            except:
                print('simulation-components is not installed')
                working_dir=input('directory :')
        return start_job(scenario, 
              **{'target': 'LocalProcess', 'working_dir': working_dir})

def start_kube(scenario):
    start_job(scenario, 
              **{'target': 'Kubernetes', 'working_dir': '/sim/sim_components/sim_components', 
                 'image': "eu.gcr.io/simtool-208411/sim_job:0.1.21",
                'node-pool': 'sim-worker-1cpu-preemptive',
                 'cpu-request': '0.6'
                })

def get_item_matching_keys(list_of_dicts, **keys):
    for d in list_of_dicts:
        #print(d)
        match = True
        for k, v in keys.items():
            match =  match and d[k] == v
        
        if match:
            return d
        
    return None
