from job_worker import job_mongodb_store
from ftpsync.targets import FsTarget
from ftpsync.ftp_target import FtpTarget
from ftpsync.synchronizers import DownloadSynchronizer, UploadSynchronizer
import os
import json

def check_create_dir(directory):
    if not os.path.exists(directory):
        os.makedirs(directory)


def save_notebook():
    return display(Javascript("IPython.notebook.save_notebook()"),
                   include=['application/javascript'])




def output_HTML(read_file, output_file):
    from nbconvert import HTMLExporter, PDFExporter
    import codecs
    import nbformat
    #exporter = HTMLExporter(template_file='nbextensions.tpl', default_template_path='/usr/local/lib/python3.6/site-packages/jupyter_contrib_nbextensions/templates')
    exporter = HTMLExporter(template_file='nbextensions.tpl',
                            default_template_path='/usr/local/lib/python3.6/site-packages/nbconvert/templates/html')
    #exporter = HTMLExporter()/usr/local/lib/python3.6/site-packages/nbconvert/templates/html#
    # read_file is '.ipynb', output_file is '.html'
    output_notebook = nbformat.read(read_file, as_version=4)
    output, resources = exporter.from_notebook_node(output_notebook)
    codecs.open(output_file, 'w', encoding='utf-8').write(output)

    # exporter_pdf = PDFExporter(template_file='nbextensions.tpl', default_template_path='/etc/jupyter')
    # read_file is '.ipynb', output_file is '.html'
    # output_notebook = nbformat.read(read_file, as_version=4)
    # output, resources = exporter_pdf.from_notebook_node(output_notebook)
    # codecs.open(output_file_pdf, 'w', encoding='utf-8').write(output)


def run_reports(report_dir, job_ref, report_definitions, tags=False):
    import papermill as pm
    report_dir = os.getcwd() + '/' + report_dir
    #print(report_dir)
    check_create_dir(report_dir + '/ipynb')
    check_create_dir(report_dir + '/html')
    # check_create_dir(report_dir+'/pdf')
    tags_=[]
    for rd in report_definitions:

        template_folder = report_dir + '/ipynb/' + rd['template']

        report_out_file = rd['name']

        report_out_file_ipynb = template_folder+'/' + report_out_file + '.ipynb'
        report_out_file_html = report_dir + '/html/' + report_out_file + '.html'
        # report_out_file_pdf = report_dir+'/pdf/'+report_out_file + '.pdf'

        if not tags:

            params = rd['parameters']
            params.update({'job_reference': job_ref, 'output_dir': report_dir + '/ipynb/'+rd['template']})


            os.chdir(template_folder)

            pm.execute_notebook(
                template_folder + '/' + rd['template'] + '.ipynb',
                report_out_file_ipynb,
                parameters=params
            )

            output_HTML(report_out_file_ipynb, report_out_file_html)
        else:
            tag_file = template_folder+'/tags.json'
            print('Tag file: ',tag_file)
            if os.path.exists(tag_file):
                print('Found tags in file: '+tag_file)
                with open(tag_file,'r') as tf:
                    new_tags=json.load(tf)
                    tags_+= new_tags['tags']
    print(tags_)
    return set(tags_)

import datetime
import pandas as pd
import numpy as np


class FileDW():

    def __init__(self, dw, file, s_up, file_count=0):
        self.s_up =s_up
        self.file = file
        self.dw = dw
        self.data_map = []
        self.complete_map = []
        self.start = datetime.datetime(2020,1,1)

        self.data_blocks = []
        self.complete_data_block = []

        self.max_blocks = 10000
        self.file_counter = file_count


    def flush(self, force=False):


        if force or len(self.data_blocks)>= self.max_blocks:
            self.dw.data_map = self.data_map
            self.dw.complete_map = self.complete_map
            self.dw.start = self.start
            self.dw.complete_data_block = self.complete_data_block
            self.dw.flush(force=force)

            print('dumping data')
            if len(self.data_blocks)>0:
                self.df = pd.DataFrame(np.array(self.data_blocks), columns=self.data_map)


                self.df.to_parquet(self.file+'_'+str(self.file_counter)+'.pqt')
                self.file_counter += 1
                self.data_blocks = []

                self.s_up.run()





#def main(job_id, job_alias, *args, **kwargs):
def main(job_id, resume_dict, spec, progress_callback=None, dw=None, continue_callback=None, **kwargs):


    if not continue_callback:
        def continue_callback():
            return True

    if not progress_callback:
        def progress_callback(progress, meta=None):
            print()
            print('***Progress update***')
            print('progress: ', progress)
            if meta:
                print('meta: ', meta)

    #print(kwargs)
    tags=set([])
    if continue_callback():
        progress_callback(0,'copying files into pod')
        #spec_id = kwargs['spec_id']

        local = FsTarget('.')
        user = kwargs['ftp_user']#"robot.user"
        passwd = kwargs['ftp_pass']#"Robottobor"



        remote_path = kwargs['remote_path']

        print(remote_path)

        remote_server = kwargs['ftp_ip']#"10.132.0.78"

        remote = FtpTarget(remote_path, remote_server, username=user, password=passwd)

        opts = {"force": True, "delete_unmatched": True, "verbose": 3}

        s = DownloadSynchronizer(local, remote, opts)
        s.run()

        report_definitions = kwargs['report_definitions']

        tags = run_reports('reports', kwargs['job_alias'], report_definitions, tags=True)
        print('the persistent tags: ', len(tags))
        if len(tags)>0:
            print('setting persisten tags. ',len(tags))
            kwargs['sim_specification']['sim_spec']['persistent_tags']=tags
        cwd_ = os.getcwd()
        imports = kwargs['imports']
        import importlib.util


        for i in imports:

            spec = importlib.util.spec_from_file_location(i[1], "/work/models/"+i[0]+"/"+i[0]+".py")
            globals()[i[1]] = importlib.util.module_from_spec(spec)
            spec.loader.exec_module(globals()[i[1]])

        print('working path: ', cwd_)

        print('doing the mong job!')
    else:
        return 'terminated'


    s_up = UploadSynchronizer(local, remote, opts)

    try:
        if continue_callback() and not kwargs['report_only']:
            progress_callback(0, 'Running simulation')

            #sys.path.append('/sim/sim_components/sim_components/thermodynamics')

            os.chdir('/sim/sim_components/sim_components')
            from google.cloud import storage
            client = storage.Client()
            bucket = client.get_bucket('rf-files.numerously.com')

            for rf_file in ['R1234yf_333_6_file.dat', 'R1234zee_333_6_file.dat', 'R134A_333_6_file.dat', 'R410A_333_6_file.dat']:


                # https://console.cloud.google.com/storage/browser/[bucket-id]/

                # Then do other things...

                blob = bucket.get_blob(rf_file)
                if blob:
                    blob.download_to_filename('thermodynamics/Interp/Interp/'+rf_file)
                else:
                    print('didnt find: '+rf_file)


            from sim_tools.job import simulation_job

            # job_mongodb_store.main(job_id, job_alias, *(spec_id,))
            file_dw = FileDW(dw, '/work/data', s_up)

            simulation_job.main(job_id, resume_dict, kwargs['sim_specification'], progress_callback=progress_callback, dw=file_dw, continue_callback=continue_callback, **{})
            os.chdir(cwd_)

        elif not continue_callback():

            return 'terminated'

        if continue_callback():

            os.chdir(cwd_)

            progress_callback(100, 'Running reports')



            run_reports('reports', kwargs['job_alias'], report_definitions)
        else:
            return 'terminated'

        if continue_callback():
            opts = {"force": True, "delete_unmatched": False, "verbose": 3}

            progress_callback(100, 'Uploading files')


            # s = DownloadSynchronizer(local, remote, opts)



            progress_callback(100, 'Completed with success!')


    except Exception as e:
        s_up.run()
        raise e

    s_up.run()
    if not continue_callback():
        return 'terminated'
    return 'finished'

if __name__ == "__main__":
    project = 'new_project'
    main(0, 'test',**dict(
        remote_path = "/opt/shared_folders/EM_simulations/Yearly_Simulations/Simulation_Project_Manager/v03/project_tool/projects/"+project+'/results/'+'group1'+'/'+'scenario1',
        report_definitions = [{'name': 'test', 'template': 'test', 'parameters': {'par': 1}}],

    ))

