import plotly.plotly as py
from plotly.offline import download_plotlyjs, init_notebook_mode, plot, iplot
import plotly.graph_objs as go
import numpy as np
import pandas as pd
from job_worker.job_models import *


try:
    init_notebook_mode(connected=True)
except Error as e:
    print('maybe not in notebook mode?')
    print(e)

class dot_dict():
    def __init__(self, dictionary: dict):
        for k,v in dictionary.items():
            setattr(self,k,v)

def makeplot(layo, y, range_slider=False):
    data = []
    for s in y:
        data += [go.Scatter(x=s[0],
                            y=s[1], name=s[2])]

    if range_slider:
        layout = dict(
            title=layo[0],
            yaxis=dict(
                title=layo[2],
            ),
            xaxis=dict(
                title=layo[1],
                rangeselector=dict(
                    buttons=list([
                        dict(count=1,
                             label='1m',
                             step='month',
                             stepmode='backward'),
                        dict(count=6,
                             label='6m',
                             step='month',
                             stepmode='backward'),
                        dict(count=1,
                             label='YTD',
                             step='year',
                             stepmode='todate'),
                        dict(count=1,
                             label='1y',
                             step='year',
                             stepmode='backward'),
                        dict(step='all')
                    ])
                ),
                rangeslider=dict(),
                type='date'
            )
        )
    else:
        layout = dict(
            title=layo[0],
            xaxis=dict(
                title=layo[1],
            ),
            yaxis=dict(
                title=layo[2],

            )
        )

    fig = dict(data=data, layout=layout)
    iplot(fig)

def makebar(layo, y, stack=False):
    data = []
    for s in y:
        data += [go.Bar(x=s[0],
                        y=s[1], name=s[2])]

    layout = dict(
        title=layo[0],
        xaxis=dict(
            title=layo[1],
        ),
        yaxis=dict(
            title=layo[2],

        )
    )
    if stack:
        layout['barmode'] = 'stack'
    fig = dict(data=data, layout=layout)
    iplot(fig)



def create_plot_from_def_df(pd, df):
    series = []

    for t in pd.tags:
        for y in pd.y_values:
            if len(t) > 0:
                series.append((df.index, df[('Stub.' + t + '.' + y[0])], t + ' ' + y[1]))
            else:
                series.append((df.index, df[('Stub.' + y[0])], t + ' ' + y[1]))


    makeplot([pd.title, pd.x_title, pd.y_title], series, range_slider=False)

def create_plot_list_def_df(plot_defs, df):




    for pd in plot_defs:
        create_plot_from_def_df(pd, df)


def get_df_job_alias(job_alias, tags):
    job_out = JobOutput.objects.get(job_alias=job_alias)
    data_stream = job_out.data_set.data_streams[0]


    df = data_stream.get_df(tags)
    return df


def create_plot_list_def_df_job(job_alias, plot_defs):
    plot_defs = [dot_dict(d) for d in plot_defs]
    tags = ['t']
    for pd in plot_defs:
        for t in pd.tags:
            for y in pd.y_values:
                if len(t) > 0:
                    tags.append('Stub.' + t + '.' + y[0])
                else:
                    tags.append('Stub.' + y[0])

    df = get_df_job_alias(job_alias, tags)
    create_plot_list_def_df(plot_defs, df)