if __name__ == '__main__':
    import jsonpickle

    from sim_tool_EM.EM_SCOP_Project import Stub
    from sim_tools.store.models_mongoengine import EM_Static_COP, Config

    inp = EM_Static_COP(name='model',
                                    Chilled_System_Temperature=4,
                                    Chilled_System_Return_dT=4,
                                    Heating_System_Temperature=45,
                                    Heating_System_Return_dT=10,
                                    Hot_Water_Temperature=55,
                                    Cold_Water_Temperature=10,
                                    Heating_System_Power=350,
                                    Hot_Water_Flow=0,
                                    EM=Config.objects.get(name='EM5-2-1-2'),
                                    Rating=True)

    pt = ['Stub.Re_Chilled_system.T', 'Stub.EM.EMA.Evaporator.T_F2_Out', 'Stub.EM.EMA2.Evaporator.T_F2_Out',
          'Stub.EM.EMA3.Evaporator.T_F2_Out', 'Stub.EM.EMA.Condenser.T_F2_Out', 'Stub.EM.EMA.Pre_Cond.T',
          'Stub.EM.EMA.Pump_CW_In_Sub.m_dot', 'Stub.EM.EMA.Compressor2.P_ewma', 'Stub.EM.EMHW.HX1.T_F1A_Out',
          'Stub.EM.Pipe_4.T_pipe', 'Stub.EM.EMHW.HX2.T_F1A_Out', 'Stub.EM.Pipe_2.T_pipe',
          'Stub.EM.EMHW.VS_Bypass.pipe_C.m_dot', 'Stub.EM.EMHW.HX1.T_F2_Out', 'Stub.EM.EMHW.HX2.T_F2_Out',
          'Stub.EM.EMHW.HX3.T_F2_Out', 'Stub.EM.EMB.Evap1_Bypass.Vol.T', 'Stub.EM.EMB.Evaporator1.F2_2.T',
          'Stub.EM.EMB.Evap2_Bypass.Vol.T', 'Stub.EM.EMB.Evaporator2.T_F2_Out', 'text6045',
          'Stub.EM.EMB.Condenser2.T_F2_Out', 'Stub.EM.EMB.cond1_Bypass.Vol.T', 'Stub.EM.EMB.Pump_CW_In_Sub.m_dot',
          'Stub.EM.VoCW_EMB_In_Sub.T', 'Stub.Re_Heating_system.T', 'Stub.EM.EMB.Power_Usage', 'Stub.EM.EMB.COP',
          'Stub.EM.EMA.Power_Usage', 'Stub.EM.EMA.COP_ewma', 'Stub.EM.EMA.Compressor1.P_ewma',
          'Stub.EM.EMB.Compressor2.P_ewma', 'Stub.EM.EMB.Compressor1.P_ewma', 'Stub.EM.EMA.Pump_CW_In_Evap.m_dot',
          'Stub.EM.EMA.Pump_CW_In_Cond.m_dot', 'Stub.EM.EMA.Sub_middle.T', 'Stub.EM.EMA.Power_Heating',
          'Stub.EM.EMA.pipe_sub_in.T_pipe', 'Stub.EM.EMA.Compressor2.T_Evap', 'Stub.EM.EMA.Compressor1.T_Evap',
          'Stub.EM.EMA.Compressor2.T_Cond', 'Stub.EM.EMA.Compressor1.T_Cond', 'Stub.EM.EMB.Power_Heating',
          'Stub.EM.EMB.Pump_CW_Out_Cond1.m_dot', 'Stub.EM.EMB.pipe_cond2_In.m_dot',
          'Stub.EM.EMB.Pump_CW_In_Evap1.Act_Speed', 'Stub.EM.EMB.Pump_CW_In_Evap2.Act_Speed',
          'Stub.EM.EMA.Compressor2.T_Discharge', 'Stub.EM.EMA.Compressor1.T_Discharge',
          'Stub.EM.EMB.Compressor1.T_Discharge', 'Stub.EM.EMB.Compressor2.T_Discharge',
          'Stub.EM.EMB.Compressor1.T_Evap', 'Stub.EM.EMB.Compressor2.T_Evap', 'Stub.EM.EMB.Compressor1.T_Cond',
          'Stub.EM.EMB.Subcooler.T_F2_Out', 'Stub.EM.EMB.Compressor2.State1', 'Stub.EM.EMB.Compressor1.State1',
          'Stub.EM.EMA.Compressor2.State1', 'Stub.EM.EMA.Compressor2.State2', 'Stub.EM.EMA.Compressor1.State1',
          'Stub.EM.EMA.Compressor1.State2', 'Stub.EM.EMB.Condenser1.T_F2_Out', 'Stub.EM.EMB.Compressor2.T_Cond',
          'Stub.EM.EMA.Subcool_Bypass.Reg.S_act', 'Stub.EM.EMB.cond1_Bypass.Reg.S_act',
          'Stub.EM.EMB.Evap1_Bypass.Reg.S_act', 'Stub.EM.EMB.Evap2_Bypass.Reg.S_act', 'Stub.EM.SCC.ST1.CW_1.T',
          'Stub.EM.SCC.ST2.CW_1.T', 'Stub.EM.SCC.ST3.CW_1.T', 'Stub.EM.VV_ST.CW_1.T',
          'Stub.EM.Pipe_Cond1_EMB_out_HS_Out.T_pipe', 'Stub.EM.EMA.pipe_cond_out.m_dot',
          'Stub.EM.EMA.pipe_sub_in.m_dot', 'Stub.EM.VoCW_Cond1_EMB_in.T', 'Stub.EM.VoCW_Cond2_EMB_out.T',
          'Stub.EM.EMB.cond1_Bypass.pipe_B.m_dot', 'Stub.EM.EMB.pipe_cond1_Out2.m_dot',
          'Stub.EM.Pipe_EMB_cond2_in_out.m_dot', 'Stub.EM.Pipe_EMB_cond1_cond2.m_dot',
          'Stub.EM.Pipe_EMB_cond1_in_out.m_dot', 'Stub.EM.EMB.cond1_Bypass.pipe_A.m_dot',
          'Stub.EM.EMB.pipe_cond1_Out1.m_dot', 'Stub.EM.EMB.Evap1_Bypass.pipe_A.m_dot',
          'Stub.EM.EMB.Evap2_Bypass.pipe_A.m_dot', 'Stub.EM.EMB.pipe_evap1_Out.m_dot',
          'Stub.EM.EMB.pipe_evap2_Out.m_dot', 'Stub.EM.EMB.Power_Cooling', 'Stub.EM.EMA.Power_Cooling',
          'Stub.EM.EMA.Power_Evaporator', 'Stub.EM.EMA.Power_Condenser', 'Stub.EM.EMB.Evaporator1.Q_ewma',
          'Stub.EM.EMB.Condenser1.Q_ewma', 'Stub.EM.EMB.Condenser2.Q_ewma', 'Stub.EM.EMB.Evaporator2.Q_ewma',
          'Stub.EM.SCC.ST1.CW_0.T', 'Stub.EM.SCC.ST1.CW_2.T', 'Stub.EM.SCC.ST2.CW_0.T', 'Stub.EM.SCC.ST2.CW_2.T',
          'Stub.EM.SCC.ST3.CW_0.T', 'Stub.EM.SCC.ST3.CW_2.T', 'Stub.EM.EMA.Subcooler.Q_B_ewma',
          'Stub.EM.EMB.Subcooler.Q_B_ewma', 'Stub.EM.VV_ST.CW_0.T', 'Stub.EM.VV_ST.CW_2.T', 'Stub.Real_EMA_Sub_In_T',
          'Stub.Real_EMA_Sub_Out_T', 'Stub.Real_EMA_Cond_In_T', 'Stub.Real_EMA_Cond_Out_T', 'Stub.Real_EMA_Evap_Out_T',
          'Stub.Real_Step1_Prim_Out_T', 'Stub.Real_Step1_Prim_In_T', 'Stub.Real_Step2_Prim_Out_T',
          'Stub.Real_Step2_Prim_In_T', 'Stub.Real_Step3_Prim_Out_T', 'Stub.Real_Step3_Prim_In_Flow',
          'Stub.Real_VS_ST_T', 'Stub.Real_SCC_ST1_T', 'Stub.Real_SCC_ST2_T', 'Stub.Real_SCC_ST3_T',
          'Stub.Real_EMB_Evap1_Out_T', 'Stub.Real_EMB_Evap1_In_T', 'Stub.Real_EMB_Cond1_Out_T',
          'Stub.Real_EMB_Cond2_In_T', 'Stub.Real_EMB_Cond1_In_T', 'Stub.Real_EMB_Cond2_Out_T', 'Stub.Real_EMB_Sub_In_T',
          'Stub.Real_EMB_Sub_Out_T', 'Stub.Real_HS_Out_T', 'Stub.Real_Step1_Sec_Out_T', 'Stub.Real_Step2_Sec_Out_T',
          'Stub.EM.Pipe_HS_In.m_dot', 'Stub.Real_HS_Out_mdot', 'Stub.EM.EMB.pipe_Sub_Out.m_dot',
          'Stub.EM.EMB.Pump_CW_In_Evap2.Set_Speed', 'Stub.EM.EMB.Pump_CW_In_Evap1.Set_Speed',
          'Stub.EM.Pump_HS_Out.Act_Speed', 'Stub.EM.Pump_HS_Out.Set_Speed', 'Stub.EM.EMA.Pump_CW_In_Cond.Act_Speed',
          'Stub.EM.EMA.Pump_CW_In_Cond.Set_Speed', 'Stub.EM.EMA.Pump_CW_In_Evap.Act_Speed',
          'Stub.EM.EMA.Pump_CW_In_Evap.Set_Speed', 'Stub.EM.EMA.Pump_CW_In_Sub.Act_Speed',
          'Stub.EM.EMA.Pump_CW_In_Sub.Set_Speed', 'Stub.EM.EMHW.P1_Prim.Act_Speed', 'Stub.EM.EMHW.P1_Prim.Set_Speed',
          'Stub.EM.EMHW.P2_Prim.Act_Speed', 'Stub.EM.EMHW.P2_Prim.Set_Speed', 'Stub.EM.EMHW.P3_Prim.Act_Speed',
          'Stub.EM.EMHW.P3_Prim.Set_Speed', 'Stub.EM.EMHW.VS_Bypass.Reg.S_act', 'Stub.Real_HW_Out_T',
          'Stub.EM.Cold_Water_Pipe.m_dot', 'Stub.EM.EMB.Pump_CW_Out_Cond1.Act_Speed',
          'Stub.EM.EMB.Pump_CW_Out_Cond1.Set_Speed', 'Stub.EM.EMB.Pump_CW_Out_Cond2.Act_Speed',
          'Stub.EM.EMB.Pump_CW_Out_Cond2.Set_Speed', 'Stub.Real_EMB_Evap2_In_T', 'Stub.Real_EMB_Evap2_Out_T',
          'Stub.EM.EMHW.P_VVC.Act_Speed', 'Stub.EM.EMHW.P_VVC.Set_Speed', 'Stub.EM.EMB.Pump_CW_Out_Cond2.m_dot',
          'Stub.Re_Heating_system.T_Set', 'Stub.EM.EMHW.VS_Bypass.pipe_A.m_dot', 'Stub.EM.Pipe_7.m_dot',
          'Stub.EM.EMHW.VS_Bypass.pipe_B.m_dot', 'Stub.EM.EMHW.Pipe_5.m_dot', 'Stub.EM.EMHW.Pipe_6.m_dot',
          'Stub.EM.EMHW.P_VVC.m_dot', 'Stub.EM.Pipe_8.m_dot', 'Stub.EM.EMHW.VS_Bypass.pipe_C.T_pipe',
          'Stub.EM.EMHW.HX3.T_F1A_Out', 'Stub.EM.Pipe_4.m_dot', 'Stub.EM.EMHW.P1_Prim.m_dot',
          'Stub.EM.EMHW.P2_Prim.m_dot', 'Stub.EM.Pipe_2.m_dot', 'Stub.EM.SCC.Pipe_1.m_dot', 'Stub.EM.SCC.Pipe_2.m_dot',
          'Stub.EM.EMB.Evap1_Bypass.pipe_B.m_dot', 'Stub.EM.EMB.Evap2_Bypass.pipe_B.m_dot',
          'Stub.EM.EMB.Pump_CW_In_Evap1.m_dot', 'Stub.EM.EMB.Pump_CW_In_Evap2.m_dot',
          'Stub.EM.EMB.cond1_Bypass.pipe_C.m_dot', 'Stub.EM.Pipe_HS_Out.m_dot', 'Stub.EM.Pipe_EMB_sub_in_out.m_dot',
          'Stub.EM.EMA.pipe_Sub_Out_Pre_Cond.m_dot', 'Stub.EM.EMB.Pump_CW_In_Sub.Act_Speed',
          'Stub.EM.EMB.Pump_CW_In_Sub.Set_Speed', 'Stub.EM.EMA.Subcool_Bypass.pipe_A.m_dot',
          'Stub.EM.EMA.Subcool_Bypass.pipe_B.m_dot', 'Stub.EM.EMA.pipe_cond_in.m_dot', 'Stub.EM.EMHW.P3_Prim.m_dot',
          'Stub.Real_Step3_Prim_In_T', 'Stub.Re_Cold_Water_supply.T_Set', 'Stub.Real_Power_Usage_EMA',
          'Stub.Real_Power_Space_Heating', 'Stub.Real_HW_Out_P', 'Stub.EM.EMHW.Step3_Prim_EM.P_ewma',
          'Stub.Real_CW_In_P', 'Stub.EM.HW_Initial_EM.P_ewma', 'Stub.EM.HS_EM.P_ewma', 'Stub.Real_Power_Usage_EMB',
          'Stub.EM.Pipe_ReCW_Sub_in.T_pipe', 'Stub.Real_EM_HS_Sub_In_T', 'Stub.Real_EM_HS_In_T',
          'Stub.Real_EM_HS_Out_T', 'Stub.EM.Pipe_HS_Out.T_pipe', 'Stub.EM.Pipe_HS_In_HS_Out.m_dot', 't',
          'Stub.Real_EMA_Comp1_Discharge_T', 'Stub.Real_EMA_Comp2_Discharge_T', 'Stub.EM.EMB.Subcooler.Q_A_ewma',
          'Stub.EM.EMA.Subcooler.Q_A_ewma', 'Stub.Real_EMB_Comp1_Discharge_T', 'Stub.Real_EMB_Comp2_Discharge_T',
          'Stub.Re_Chilled_system.T2', 'Stub.EM.EMA2.Evaporator.F2_5.T', 'Stub.EM.EMA2.Condenser.T_F2_Out',
          'Stub.EM.EMA2.Pre_Cond.T', 'Stub.EM.EMA2.Pump_CW_In_Sub.m_dot', 'Stub.EM.EMA2.Compressor2.P_ewma',
          'Stub.EM.EMA2.Compressor1.P_ewma', 'Stub.EM.EMA2.Pump_CW_In_Evap.m_dot', 'Stub.EM.EMA2.Pump_CW_In_Cond.m_dot',
          'Stub.EM.EMA.Sub_middle.T-2', 'Stub.EM.EMA2.pipe_sub_in.T_pipe', 'Stub.EM.EMA2.Compressor2.T_Evap',
          'Stub.EM.EMA2.Compressor1.T_Evap', 'Stub.EM.EMA2.Compressor2.T_Cond', 'Stub.EM.EMA2.Compressor1.T_Cond',
          'Stub.EM.EMA2.Compressor2.T_Discharge', 'Stub.EM.EMA2.Compressor1.T_Discharge',
          'Stub.EM.EMA2.Compressor2.State1', 'Stub.EM.EMA2.Compressor2.State2', 'Stub.EM.EMA2.Compressor1.State1',
          'Stub.EM.EMA2.Compressor1.State2', 'Stub.EM.EMA2.Subcool_Bypass.Reg.S_act',
          'Stub.EM.EMA2.pipe_cond_out.m_dot', 'Stub.EM.EMA2.pipe_sub_in.m_dot', 'Stub.EM.EMA2.Power_Evaporator',
          'Stub.EM.EMA2.Power_Condenser', 'Stub.EM.EMA2.Subcooler.Q_B_ewma', 'Stub.Real_EMA_Sub_In_T-1',
          'Stub.Real_EMA_Sub_Out_T-3', 'Stub.Real_EMA_Cond_In_T-2', 'Stub.Real_EMA_Cond_Out_T-1',
          'Stub.Real_EMA2_Evap_Out_T', 'Stub.EM.EMA2.Pump_CW_In_Cond.Act_Speed',
          'Stub.EM.EMA2.Pump_CW_In_Cond.Set_Speed', 'Stub.EM.EMA2.Pump_CW_In_Evap.Act_Speed',
          'Stub.EM.EMA2.Pump_CW_In_Evap.Set_Speed', 'Stub.EM.EMA2.Pump_CW_In_Sub.Act_Speed',
          'Stub.EM.EMA2.Pump_CW_In_Sub.Set_Speed', 'Stub.EM.EMA2.pipe_Sub_Out_Pre_Cond.m_dot',
          'Stub.EM.EMA2.Subcool_Bypass.pipe_A.m_dot', 'Stub.EM.EMA2.Subcool_Bypass.pipe_B.m_dot',
          'Stub.EM.EMA2.pipe_cond_in.m_dot', 'Stub.Real_EMA2_Comp1_Discharge_T', 'Stub.Real_EMA2_Comp2_Discharge_T',
          'Stub.EM.EMA2.Subcooler.Q_A_ewma', 'Stub.EM.EMA2.Power_Usage', 'Stub.EM.EMA2.COP_ewma',
          'Stub.EM.EMA2.Power_Heating', 'Stub.EM.EMA2.Power_Cooling', 'Stub.Real_Power_Usage_EMA-6',
          'Stub.EM.Power_Consumption', 'Stub.EM.Space_Heating_COP', 'Stub.EM.Space_Heating_Power', 'Stub.EM.Total_COP',
          'Stub.Real_Power_Usage', 'Stub.Real_COP', 'Stub.EM.Pipe_EMA_2.m_dot', 'Stub.EM.VoCW_Cond_EMA.T',
          'Stub.EM.VoCW_Cond_EMA2.T', 'Stub.EM_Reg.P_HW_act', 'Stub.EM_Reg.P_HS_act', 'Stub.EM_Reg.P_Add_HW',
          'Stub.EM_Reg.P_Add_HS', 'Stub.EM_Reg.P_HS', 'Stub.EM.Energy_Consumption', 'Stub.EM_Reg.Energy_HS',
          'Stub.EM_Reg.Energy_HW', 'Stub.EM_Reg.Energy_Add_HS', 'Stub.EM_Reg.Energy_Add_HW', 'Stub.EM_Reg.T_HS',
          'Stub.Re_Chilled_system.T_Set', 'Stub.EM_Reg.T_HW', 'Stub.Re_Hot_Water_system.T',
          'Stub.EM.TW_HS_HW_in.Reg.S_set', ]

    sim_specification = {
        'model_spec': {'class': jsonpickle.dumps(Stub), 'args': jsonpickle.dumps([inp]), 'kwargs': {}},
        'sim_spec': {'dt': 100, 't_end': 1000, 'persistent_tags': pt}
    }

    job_def = {
        'reraise_errors': True,
        'path': '../../sim/sim_tool_EM',
        'script': 'job_worker.job_mongodb_store',
        'args': [],
        'kwargs': {
            'script': 'job_worker.simulation',
            'args': [sim_specification],
            'kwargs': {}
        }
    }

    from basic_models.models import *
    from job_worker.job_models import *

    alias = 'test5'
    #job_info = JobInfo(alias=alias)
    #job_info.save()
    #args = ['script_name', str(job_info.id), json.dumps(job_def)]
    #from job_worker.job import main
    #main(args)

    #from job_worker.simulation import main
    #import os
    #print(os.getcwd())
    #os.chdir('../../sim/sim_tool_EM')
    #main(1, sim_specification, progress_callback=None)

    job_info = JobInfo.objects.get(alias=alias)
    job_out = JobOutput.objects.get(job=job_info.id)

    ds=job_out.data_set
    print(ds.data_streams[0].get_block(1,pt[0:2]))

    print(ds.data_streams[0].get_tags(pt[0:2]))