
import time
import pymongo
import datetime
import os
import sim_components.generic.items as B

Sandbox="mongodb://LasseThomsen:ziQPn556jjRaxY6x@cluster0-shard-00-00-9vgq3.mongodb.net:27017,cluster0-shard-00-01-9vgq3.mongodb.net:27017,cluster0-shard-00-02-9vgq3.mongodb.net:27017/test?ssl=true&replicaSet=Cluster0-shard-0&authSource=admin"
ReliableServer="mongodb://sim:m9Yx8ip6P88i@209.222.108.162:28017/sim_config?authSource=admin"
GCE_Kubernetes="mongodb://sim:m9Yx8ip6P88i@35.195.195.235:27017/sim_config?authSource=admin"

Default_MongoDB_URI=GCE_Kubernetes

class Simulation_Store():
    def __init__(self, MongoDB_URI=Default_MongoDB_URI):
        self.pmClient = pymongo.MongoClient(Default_MongoDB_URI)
        self.db=self.pmClient.sim_config
    
    def list_configurations(self, filter={}, print_=False):
        res=self.db.configs.find(filter)
        if print_:
            for r in res:
                print(r['Name']+'---'+r['Description']+'-'+r['Comment']+' - '+str(r['TimeStamp']) +' - '+r['User'])
        else:
            return res
    
    def migrate_configurations(self, pmClient):
        res=self.db.configs.find({})
        
        db=pmClient.test
        for r in res:
            db.configs.insert_one(r)
    
    def new_Run(self, name,**c):
        self.name=name
        c.update({'Name':name, 'TimeStamp': time.time(), 'DateTime': datetime.datetime.today(), 'User':os.getlogin()})
        self.run_id=self.db.sim_runs.insert_one(c).inserted_id
        self.sim_result_ids=[]
        print('Results are saved with run_id: ' + str(self.run_id))

    def store_Step_Result(self,in_dict):
        #print('storing')
        mongo_dict={'Sim_name':self.name, 'Run_id':str(self.run_id)}
        mongo_dict.update(dict(zip([p.replace('.','/') for p in in_dict.keys()],in_dict.values())))
    
        self.sim_result_ids += [self.db.sim_results.insert_one(mongo_dict).inserted_id]
        return self.sim_result_ids
        
    def condense_Step_Results(self):
        
        loaded_results=self.db.sim_results.find({'Run_id': str(self.run_id)})
        loaded_dict={}
        ids=[]
        for i, lr in enumerate(loaded_results):
            
            for k,v in lr.items():
                
                if k!='_id':
                    if i==0:
                        loaded_dict[k]=[]
                    loaded_dict[k].append(v)
                else:
                    ids.append(v)
                    
                    
        #print(loaded_dict['Solver/convergence'])
        self.store_Step_Result(loaded_dict)
        for id in ids:
            
            self.db.sim_results.remove({'_id':id})
    
    def get_Step_Results(self,id):
        loaded_res=self.db.sim_results.find({'Run_id': id})
        #print(loaded_dict)
        #print(loaded_dict[1]['Solver/convergence'])
        #loaded_dict=loaded_res[len(loaded_res)-1]
        loaded_dict={}
        for i, lr in enumerate(loaded_res):
            
            for k,v in lr.items():
                if k!='_id':
                    if i==0:
                        loaded_dict[k]=[]
                    loaded_dict[k]+=v
                          
        loaded_dict=dict(zip([p.replace('/','.') for p in loaded_dict.keys()],loaded_dict.values()))
        return loaded_dict
    
    def store_Config(self, conf, overwrite=False):
        conf.update({'TimeStamp': time.time(), 'DateTime': datetime.datetime.today(), 'User':os.getlogin()})
        if overwrite:
            resp=self.db.configs.find_and_modify(query={'Name': conf['Name']},update={'$set': conf},upsert=True, full_response= True)
            print(resp)
            conf_id=0
            #conf_id=resp['value']['_id']
        else:
            conf_id=self.db.configs.insert_one(conf).inserted_id
        return conf_id
        
    def get_Config_by_Name(self, name):
        return self.db.configs.find({'Name': name})
    
    def get_Config_by_id(self, id):
        return self.db.configs.find({'_id': id})
        
    def close(self):
        self.pmClient.close()
        
class Item_Factory(B.Item_Factory):
    def __init__(self, name, MongoDB_URI=Default_MongoDB_URI):
        """
        Args:
            name (str): Descriptive name of the Item_Factory
        """
        self.name=name
        self.Item_Store=Simulation_Store(MongoDB_URI)
        
    def getConfig(self, config_name):
        try:
            #print('Gettig config: ' +config_name)
            #print(config_name)
            found_configs=self.Item_Store.get_Config_by_Name(config_name)
            tConf=found_configs[0]
            c=tConf.pop('Configuration')
            #print(tConf)
            return c
        except IndexError as ie:
            raise ReferenceError('Config not found: '+config_name)
    
    def get_Item(self, name, parent_path, anItem=None, *Args, **key_param):
        #print('anItem in: ',anItem)
        #try:
            if not anItem:
                modulename, decim, classname = key_param['item_class'].rpartition('.')
                #print('item class str: ',key_param['item_class'])
                #print('mod: ',modulename)
                #print('class: ',classname)

                #print(modulename)
                #if modulename == 'Local_EM_Regulator':
                import inspect
                #print(len(inspect.stack()))
                found = False
                for i in range(len(inspect.stack())):
                    try:
                        caller_globals = dict(inspect.getmembers(inspect.stack()[i][0]))["f_globals"]
                        #print(caller_globals)
                        #print(i)
                     
                        anItem = getattr(caller_globals[modulename], classname)
                        found=True
                        break
                    except:
                        pass
                if not found:
                    #print(globals())
                    #print('Could not get item from globals will load it\'s module')
                    import importlib
                    module =  importlib.import_module(modulename)
                    anItem = getattr(module, classname)

            attr={}
            #print('sdf')
            if ('Config' in key_param):
                if (key_param['Config']=='Default'):
                    key_param.update(anItem.getDefault())
                else:
                    if isinstance(key_param['Config'], str):
                        conf = self.getConfig(key_param['Config'])
                        conf.update(key_param)
                        key_param = conf
                    elif isinstance(key_param['Config'], dict):
                        key_param.update(key_param['Config'])
                    else:
                        raise(TypeError('Config must be dict or str not <'+type(key_param['Config'])+'>'))

                key_param.pop('Config')

            if('Add' in key_param):
                key_param.update(key_param['Add'])
                key_param.pop('Add')

            if 'item_class' in key_param:
                key_param.pop('item_class')
            return anItem(name,parent_path,self,*Args,**key_param)
        #except TypeError as te:
         #   raise TypeError(name +' is not a class: ' + str(anItem))

       
    def store_Item(self,name,desc,comm,conf):
        print('Storing config: ' +name)
        return self.Item_Store.store_Config({'Name':name, 'Description': desc, 'Comment': comm, 'Configuration':conf})

if __name__ == '__main__':
    ss=Simulation_Store()
    ss.list_configurations(print_=True)